--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Ada.Text_IO;

with Nomo.Type_Categories;

with Nomo.Numerics.Times;

package Nomo.Internal_Messages.Conclusions.Printing is

   use Ada.Text_IO;
   use Type_Categories;

   generic
      type Internal_Type_Index is (<>);
   package CVS is

      procedure Put_Header (File : in out File_Type);

      procedure Put_NA (File : in out File_Type);

      procedure Put (File     : in out File_Type;
                     This     : in Internal_Conclusion;
                     Category : in Type_Category;
                     Id       : in Internal_Type_Index);

   end CVS;

   generic
      type Component_Index is (<>);
      type Internal_Type_Index is (<>);
      type External_Message is limited private;
      with procedure Put (File : in out File_Type;
                          This : in External_Message;
                          Size : in Component_Index);
   package XML is

      procedure Put (File     : in out File_Type;
                     This     : in Internal_Conclusion;
                     Category : in Type_Category;
                     Id       : in Internal_Type_Index;
                     Output   : in External_Message;
                     Size     : in Component_Index);

   end XML;

   package DB is

      use Numerics.Times;

      procedure Put (File    : in out File_Type;
                     T       : in Time;
                     Rule_Id : in Positive;
                     This    : in Internal_Conclusion);

   end DB;

end Nomo.Internal_Messages.Conclusions.Printing;
