--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Ada.Text_IO;

with Nomo.Numerics.Times;

with Nomo.Type_Categories;

generic
   with function Get_Category (I : in Internal_Type_Index) return Nomo.Type_Categories.Type_Category;
package Nomo.Gen_Rule_Storages.Full_Printing is

   use Ada.Text_IO;
   use Numerics.Times;

   generic
      with procedure Put_External_Premise_Header (File : in out File_Type);
      with procedure Put_CVS (File : in out File_Type; This : in External_Premise);
      with procedure Put_External_Premise_NA (File : in out File_Type);
      with procedure Put_Internal_Premises_Header (File : in out File_Type);
      with procedure Put_CVS (File : in out File_Type; This : in Internal_Premises; Types : in Internal_Premises_Types; Properties : in Internal_Premises_Properties; Last : in Premise_Index);
      with procedure Put_External_Message_Header (File : in out File_Type);
      with procedure Put_CVS (File : in out File_Type; This : in External_Message; Size : in Component_Index);
      with procedure Put_External_Message_NA (File : in out File_Type);
   package CVS is

      procedure Put_Header (File : in out File_Type);

      procedure Put (File : in out File_Type;
                     This : in Full_Rule_Storage;
                     T    : in Time);

   end CVS;

   generic
      with procedure Put_XML (File : in out File_Type; This : in External_Premise; Type_Id : in Positive);
      with procedure Put_XML (File : in out File_Type; This : in Internal_Premises; Types : in Internal_Premises_Types; Properties : in Internal_Premises_Properties; Last : in Premise_Index);
      with procedure Put_XML (File : in out File_Type; This : in External_Message; Size : in Component_Index);
   package XML is

      procedure Put_Header (File : in out File_Type);

      procedure Put (File : in out File_Type;
                     This : in Full_Rule_Storage;
                     T    : in Time);

      procedure Put_Ending (File : in out File_Type);

   end XML;

   generic
      with procedure Put_DB (File : in out File_Type; T : in Time; Rule_Id : in Positive; This : in External_Premise);
      with procedure Put_DB (File : in out File_Type; T : in Time; Rule_Id : in Positive; This : in Internal_Premises; Types : in Internal_Premises_Types; Properties : in Internal_Premises_Properties; Last : in Premise_Index);
      with procedure Put_DB (File : in out File_Type; T : in Time; Rule_Id : in Positive; This : in External_Message; Size : in Component_Index);
   package DB is

      procedure Create (Path : in string);

      procedure Open (Path : in string);

      procedure Put (This : in Full_Rule_Storage;
                     T    : in Time);

      procedure Close;

   private

      Log        : File_Type;
      Rule      : File_Type;
      Input      : File_Type;
      Output     : File_Type;
      Premise    : File_Type;
      Conclusion : File_Type;

      procedure Create_Log (Path : in String);
      procedure Open_Rule (Path : in String);
      procedure Create_Input (Path : in String);
      procedure Create_Output (Path : in String);
      procedure Create_Premise (Path : in String);
      procedure Create_Conclusion (Path : in String);

   end DB;

end Nomo.Gen_Rule_Storages.Full_Printing;
