//  Copyright (2010-2013) Cédric Coussinet (cedric.coussinet@nomoseed.net)
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published
//  by the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program. If not, see <http://www.gnu.org/licenses/>

#ifndef RECEPTION_H
#define RECEPTION_H

#include "module.h"
#include "mainwindow.h"

class Reception : public Module<Reception>
{

  Q_OBJECT

  friend class Module<Reception>;

private:

  Reception (QMainWindow * mainWindow, QWebView * webView);
  ~Reception ();

  QString projectName;
  nomoProjectType projectType;
  QString projectFormalism;

public slots:

    void openProject ();
    void openDatabase ();
    void changeLanguage (QString languageName);
    void setProjectType (const QString projectType);
    void setProjectName (const QString projectName);
    void chooseProjectLocation ();

    void populateJavaScriptWindowObject ();
};

#endif // RECEPTION_H
