﻿//  Copyright (2010-2013) Cédric Coussinet (cedric.coussinet@nomoseed.net)
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published
//  by the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program. If not, see <http://www.gnu.org/licenses/>

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui/QMainWindow>
#include <QLocale>

#include "editor.h"

#include "benchmark.h"

#include "logging.h"

#if WIN32
const QString toolsName = "nomoTools";
#else
const QString toolsName = "./nomoTools";
#endif

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:

    explicit MainWindow(const QLocale locale, QString arg, QWidget *parent = 0);
    ~MainWindow();

    void selectProject();

    void openLogging (const QString path);

    void closeTabEditor();

    void createProject (nomoProjectType label, const QString projectPath, const QString projectName, const QString projectFormalism);

    QLocale getLocale();

    QStringList selectFile(QString title, QString list);


public  slots:

    void openProject();

    void openProject(const QString path);

private slots:

    void on_createButton_clicked();

    void on_openButton_clicked();

    void on_saveButton_clicked();

    void on_helpButton_clicked();

    void on_tabWidget_tabCloseRequested(int index);

    void on_tabWidget_destroyed();

    void on_tabWidget_currentChanged(int index);

private:

    Ui::MainWindow *ui;

    QTabWidget * tabWidget;

    QWidget * backgroundWidget;

    QWidget * buttonsWidget;

    QWidget * receptionTab;

    QWidget * editorTab;
    Editor * editor;

    QWidget * benchmarkTab;
    Benchmark * benchmark;

    QWidget * loggingTab;
    Logging * logging;

    QWidget * manualTab;
    QString beginManualPath;
    QString endManualPath;

    QLocale locale;

    void resizeEvent(QResizeEvent *);

    void showReception ();

    void hiddenReception ();

    void updateTab(QWidget * tab);

    QString arg;

};

#endif // MAINWINDOW_H
