//  Copyright (2010-2013) Cédric Coussinet (cedric.coussinet@nomoseed.net)
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published
//  by the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program. If not, see <http://www.gnu.org/licenses/>

#ifndef LOGGING_H
#define LOGGING_H

#include <QProcess>

#include "module.h"

class Logging : public Module<Logging>
{

    Q_OBJECT

    friend class Module<Logging>;

public:

    QString openDB(const QString path);

    void openSQL (const QString path);

    void close();

public slots:

    void openDatabase ();

    void addDatabase ();

    void resetDatabase ();

    void outputR();

    void errorR();

    void graphicView(const QString sql);

    void tableView(const QString sql);

    void exportView();

    void populateJavaScriptWindowObject ();

private:

    Logging (QMainWindow * mainWindow, QWebView * webView);
    ~Logging ();

    QString validateDB(const QString path);

    void showGraphicView();

    void showTableView();

    QString pathDB;
    QString pathSQL;
    QProcess rProcess;

};

#endif // LOGGING_H
