//  Copyright (2010-2013) Cédric Coussinet (cedric.coussinet@nomoseed.net)
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published
//  by the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program. If not, see <http://www.gnu.org/licenses/>

#ifndef EDITOR_H
#define EDITOR_H

#include <QtGui/qmainwindow.h>
#include <QtWebKit/QWebView>
#include <QObject>

#include "xsltprocessor.h"

#include "module.h"

enum nomoProjectType {mod, prg, eng, bas, uni, map, pts, cod, lnk, pr, fr, sql, error};

nomoProjectType toProjectType(const QString ext);

QString toQString(const nomoProjectType ext);

QString toName(const nomoProjectType projectType);

class Editor : public Module<Editor>
{

    Q_OBJECT

    friend class Module<Editor>;

public:

    QString open (const QString path, const nomoProjectType projectType);

    void close();

public slots:

    void populateJavaScriptWindowObject ();

    QString parse(const QString xml, const QString isRef);

    QString link();

    QString saveAll();

    void update(const QString data);

    bool updateCSS();

    void updateText();

    QString toHSL(const int r, const int g, const int b );

    void activeColor(const QString name);

    void setColor(const QString hue, const QString sturation);

    void setCurrentWorkspace(const QString number);

    QString isModified(const QString number);

    QString getCurrentWorkspace();

    QString openWorkspace(const QString path, const int id);

    QString closeWorkspace();

    QString save(const int number);

    void createProject(const nomoProjectType projectType, const QString projectPath, const QString projectName, const QString projectFormalism);

    QString getDefaultProject();

    void setInterface(const QString language, const QString extension);

private:

    Editor (QMainWindow * mainWindow, QWebView * webView);
    ~Editor ();

    struct element {
        XSLTProcessor * toHTML;
        XSLTProcessor * toXML;
        xmlDocPtr doc;
        QString path;
        QString name;
        QString type;
        QString modified;
    };

    QList<element> listElements;
    QList<XSLTProcessor*> listWorkspaces;
    XSLTProcessor navigation;
    XSLTProcessor css;
    xmlNodePtr color;
    int current;

    void updateGrammarSDK(const QByteArray name);
    QString link_model();
    QString link_program();
    QString link_unit();

    QString languageInterface;
    QString extensionInterface;

    QString cache;
};

#endif // EDITOR_H
