--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Interfaces.C.Strings;

with System;

package Nomo_Interpreter is

   type Log_Flag is (Winner_Partial,
                     Winner_Full,
                     All_Rule_Partial,
                     All_Rule_Full,
                     No_Log);
   for Log_Flag use (Winner_Partial   => 0,
                     Winner_Full      => 1,
                     All_Rule_Partial => 2,
                     All_Rule_Full    => 3,
                     No_Log           => 4);
   pragma Convention (C, Log_Flag);

   type File_Flag is (New_Full_File,
                      New_Partial_File,
                      New_Files,
                      No,
                      Temp);
   for File_Flag use (New_Full_File    => 0,
                      New_Partial_File => 1,
                      New_Files        => 2,
                      No               => 3,
                      Temp             => 4);
   pragma Convention (C, File_Flag);

   type Finalization_Flag is (Any_Modification,
                              Save_Seed,
                              Update_Seed);
   for Finalization_Flag use (Any_Modification => 0,
                              Save_Seed        => 1,
                              Update_Seed      => 2);
   pragma Convention (C, Finalization_Flag);


   type Log_Position_Flag is (Before_Assume,
                              After_Assume);
   for Log_Position_Flag use (Before_Assume => 0,
                              After_Assume  => 1);

   type Real is digits 6 range -16#0.FFFF_FF#E32 .. 16#0.FFFF_FF#E32;
   for Real'Size use 32;
   pragma Convention (C, Real);

   subtype Real_0_To_1 is Real range 0.0 .. 1.0;

   type Callback is access procedure (Intensity : in Real_0_To_1;
                                      Data      : in System.Address);
   pragma Convention (C, Callback);

   type Callbacks is array (Natural Range <>) of Callback;
   pragma Convention (C, Callbacks);

end Nomo_Interpreter;
