--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

package Nomo.Tolerances is

   pragma Pure;

   type Tolerance_Flag is (IN_TN_CN,
                           IN_TN_CI,
                           II_TN_CN,
                           II_TN_CI,
                           IN_TI_CN,
                           IN_TI_CI,
                           II_TI_CN,
                           II_TI_CI,
                           II_TI_CP,
                           IN_TI_CP,
                           II_TN_CP,
                           IN_TN_CP,
                           II_TP_CP,
                           IN_TP_CP,
                           II_TP_CN,
                           II_TP_CI,
                           IN_TP_CN,
                           IN_TP_CI);
   pragma Ordered (Tolerance_Flag);
   --  Drapeau indiquant le type de tolrance pour l'information (I), l'tiquette temporelle (T),
   --  et la crdibilit (C). Pour l'information, la tolrance peut tre soit nulle (N) soit
   --  infinie (I). Tout comme pour l'tiquette temporelle et la crdibilit mais, pour ces deux
   --  dernires variables, une tolrance pondre (P) peut tre appliqu.
   --  L'criture mnmotechnique suit la logique suivante :
   --  information (I) + (N ou P ou I)_tiquette temporelle (T) + (N ou P ou I)_crdibilit (C) + (N ou P ou I)

end Nomo.Tolerances;
