--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter_Parameters;

package body Nomo.Reader.Sizes is

   use Interpreter_Parameters;

   function Get_Number_Of_Types return Positive is
      Data : Engine_Parameters;
   begin
      Engine_Parameters'Read(Reader.Get_Binary_Stream(Engine), Data);
      return Data.Number_Of_Types;
   end Get_Number_Of_Types;

   function Get_Number_Of_Rules return Positive is
      Data : Engine_Parameters;
   begin
      Engine_Parameters'Read(Reader.Get_Binary_Stream(Engine), Data);
      return Data.Number_Of_Rules;
   end Get_Number_Of_Rules;

end Nomo.Reader.Sizes;
