--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

package Nomo.Numerics.Times is

   pragma Pure;

   type Time is range -(2 ** 63- 1) .. +(2 ** 63 - 1);
   for Time'Size use 64;

   subtype Positive_Time is Time range 0 .. Time'Last;

   type Time_Interval is range -(2 ** 31- 1) .. +(2 ** 31 - 1);
   for Time_Interval'Size use 32;

   subtype Positive_Time_Interval is Time_Interval range 0 .. Time_Interval'Last;

   subtype Negative_Time_Interval is Time_Interval range Time_Interval'First .. 0;

end Nomo.Numerics.Times;
