--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Accurately;

package Nomo.Numerics.Reals.Elementary_Functions is

   pragma Pure;

   use Accurately;

   function Exp (X : in Real) return Real_0_To_1'Base;

   function Exp_10 (X : in Real_Accurately) return Positive_Real;
   pragma Inline (Exp_10);

   function Log_10 (X : in Strictly_Positive_Real) return Real_Accurately;
   pragma Inline (Log_10);

   function Sqrt (X : in Positive_Real'Base) return Positive_Real'Base;

end Nomo.Numerics.Reals.Elementary_Functions;
