--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Reals;

with Nomo.Numerics.Accurately;

with Nomo.Numerics.Times;

with Nomo.Numerics.Fitting;

package Nomo.Interpreter_Parameters is

   pragma Pure;

   use Numerics.Reals;

   use Numerics.Accurately;

   type Dynamic_Parameters is record
      Check_Cover        : Positive_Real;
      Bid_Rate           : Real_Accurately_0_To_1;
      Tax_Rate           : Real_Accurately_0_To_1;
      Reimbursement_Rate : Real_Accurately_0_To_1;
      Reward_Rate        : Real_Accurately_0_To_1;
      Forget             : Real_Accurately_0_To_1;
   end record;

   use Numerics.Times;

   use Numerics.Fitting;

   type Engine_Parameters is record
      Frequency                    : Strictly_Positive_Real; --  Hz
      Time_Span_Limit              : Time_Interval;  --  ms
      Maximum_Of_Maximizations     : Count;
      Maximum_Of_Internal_Events   : Positive;
      Maximum_Of_Rules_By_Type     : Positive;
      Maximum_Of_External_Events   : Positive;
      Maximum_Of_Premises          : Natural;
      Maximum_Of_Components        : Natural;
      Number_Of_Types              : Positive;
      Number_Of_Rules              : Positive;
      Number_Of_External_Operators : Natural;
      Number_Of_Internal_Operators : Natural;
      Number_Of_External_Scopes    : Natural;
      Number_Of_Internal_Scopes    : Natural;
      Number_Of_Input_Types        : Natural;
   end record;

end Nomo.Interpreter_Parameters;
