--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Types_Index.Ranges;

with Nomo.Interpreter.Components_Index;

package Nomo.Interpreter.Types_Directory.Relations is

   use Types_Index.Ranges;

   use Components_Index;
   use Types_Index.Types_Index_Instance;

   function Get_Data_Size (I : in Type_Index) return Component_Index;
   pragma Precondition (I in Command_Type_Index or I in Input_Type_Index);

   function Get_Check_Type (I : in Prediction_Type_Index) return Check_Type_Index;

   function Get_Landmark_Type (I : in Prediction_Type_Index) return Landmark_Type_Index;

   function Has_Prediction_Linked (I : in Landmark_Type_Index) return Boolean;

   function Get_Feedback (I : in Command_Type_Index) return Perception_Type_Index;

   function Has_Prediction_Type (I : in Internal_Type_Index) return Boolean;
   pragma Precondition (I in Perception_Type_Index or I in Conception_Type_Index);

   function Get_Prediction_Type (I : in Internal_Type_Index) return Prediction_Type_Index;
   pragma Precondition (I in Perception_Type_Index or I in Conception_Type_Index or I in Check_Type_Index or I in Landmark_Type_Index);

   function Get_Twin_Type (I : in Internal_Type_Index) return Conception_Type_Index;

   function Has_Reward_Type (I : in Internal_Type_Index) return Boolean;

   function Get_Reward_Type (I : in Internal_Type_Index) return Reward_Type_Index;
   pragma Precondition (not (I in Reward_Type_Index));

   function Get_Input_Type (I : in Perception_Type_Index) return Input_Type_Index;

   function Get_Perception_Type (I : in Input_Type_Index) return Perception_Type_Index;

   function Get_Command_Type (I : in Perception_Type_Index) return Command_Type_Index;

   function Has_Command_Type (I : in Perception_Type_Index) return boolean;

   function Is_Rewardable (I           : in Internal_Type_Index;
                           Reward_Type : in Reward_Type_Index) return Boolean;

   function Has_Twin_Type (I : in Internal_Type_Index) return Boolean;

   function Has_Feedback (I : in Command_Type_Index) return Boolean;

   function Has_Target (I : in Check_Type_Index) return Boolean;

   function Has_Check_Type (I : in Landmark_Type_Index) return Boolean;

end Nomo.Interpreter.Types_Directory.Relations;
