--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

package body Nomo.Interpreter.Types_Directory.Initialization is

   function First_Type (Category : in Type_Category) return Type_Index_Strict is
   begin
      for I in Type_Index_Strict'Range loop
         if Category = This (I).Category then
            return I;
         end if;
      end loop;
      return Type_Index_Strict'Last;
   end First_Type;

   function Last_Type (Category : in Type_Category) return Type_Index is
      Answer : Type_Index := Type_Index'First;
   begin
      for I in Type_Index_Strict loop
         if This (I).Category = Category and then (I = Type_Index'Last or else This (I + 1).Category /= Category) then
            Answer := I;
         end if;
      end loop;
      return Answer;
   end Last_Type;

end Nomo.Interpreter.Types_Directory.Initialization;
