--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

private with Nomo.Interpreter.Types_Index.Ranges;
pragma Elaborate_All(Nomo.Interpreter.Types_Index.Ranges);

private package Nomo.Interpreter.Targets_Rewards is

   type Targets_Reward is limited private;

private

   use Types_Index.Types_Index_Instance;
   use Types_Index.Ranges;

   type Index is new Natural range 0 .. Positive(Reward_Type_Index'First - Internal_Type_Index'First);

   type Internal_Types is array (Index'First + 1 .. Index'Last) of Internal_Type_Index;

   type Targets_Reward is limited record
      Types : Internal_Types;
      Last  : Index;
   end record;

end Nomo.Interpreter.Targets_Rewards;
