--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Reals;

with Nomo.Interpreter.Conditions_Base.Evaluation;

package body Nomo.Interpreter.Standard_Conditions is

   use Conditions_Base.Evaluation;
   use Numerics.Reals;

   procedure Evaluate (This  : in out Standard_Condition) is
      Inhibitory_Score    : Positive_Real := 0.0;
      Excitatory_Distance : Positive_Real := 0.0;
   begin
      Reset_Score (Condition_Base (This));
      Evaluate_Internal_Inhibiting_Intentions (Condition_Base(This), Inhibitory_Score);
      if Inhibitory_Score < 1.0 then
         Evaluate_Internal_Inhibiting_Evidences (Condition_Base(This), Inhibitory_Score);
         if Inhibitory_Score < 1.0 then
            Evaluate_Internal_Exciting_Intentions (Condition_Base(This), Inhibitory_Score, Excitatory_Distance);
            if Inhibitory_Score < 1.0 then
               Evaluate_Internal_Exciting_Evidences (Condition_Base(This), Inhibitory_Score, Excitatory_Distance);
               if Inhibitory_Score < 1.0 then
                  Subtract (Condition_Base (This), Excitatory_Distance, Inhibitory_Score);
               end if;
            end if;
         end if;
      end if;
   end Evaluate;

   procedure Evaluate (This  : in out Standard_Condition;
                       Shift : in Real_Accurately) is
      Inhibitory_Score    : Positive_Real := 0.0;
      Excitatory_Distance : Positive_Real := 0.0;
   begin
      Reset_Score (Condition_Base (This));
      Evaluate_Internal_Inhibiting_Intentions (Condition_Base(This), Inhibitory_Score);
      if Inhibitory_Score < 1.0 then
         Evaluate_Internal_Inhibiting_Evidences (Condition_Base(This), Inhibitory_Score);
         if Inhibitory_Score < 1.0 then
            Evaluate_Internal_Exciting_Intentions (Condition_Base(This), Inhibitory_Score, Excitatory_Distance);
            if Inhibitory_Score < 1.0 then
               Evaluate_Internal_Exciting_Evidences (Condition_Base(This), Inhibitory_Score, Excitatory_Distance);
               if Inhibitory_Score < 1.0 then
                  Subtract (Condition_Base (This), Excitatory_Distance, Inhibitory_Score, Shift);
               end if;
            end if;
         end if;
      end if;
   end Evaluate;

end Nomo.Interpreter.Standard_Conditions;
