--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Gen_Clusters_Base.Standard_Loading;
pragma Elaborate_All (Nomo.Interpreter.Gen_Clusters_Base.Standard_Loading);

with Nomo.Interpreter.Gen_Clusters_Base.Initialization;
pragma Elaborate_All (Nomo.Interpreter.Gen_Clusters_Base.Initialization);

with Nomo.Interpreter.Targets_Rewards.Initialization;

with Nomo.Interpreter.Reward_Rules.Initialization;

package body Nomo.Interpreter.Rewards_Clusters.Loading is

   package Local_Initialization is new Rewards_Clusters_Base.Initialization;

   procedure Initialize (This        : in out Rewards_Cluster;
                         Reward_Type : in Reward_Type_Index) is
      use Targets_Rewards.Initialization;
      use Local_Initialization;
   begin
      This.Reward_Type := Reward_Type;
      Initialize(Reward_Type, This.Targets);
      Initialize (Cluster_Base (This));
   end Initialize;

   package Local_Loading is new Rewards_Clusters_Base.Standard_Loading (Reward_Rules.Initialization.Initialize);

   function Has_Space (This : in Rewards_Cluster) return Boolean is
   begin
      return Local_Loading.Has_Space (Cluster_Base (This));
   end Has_Space;

   procedure Load (This             : in out Rewards_Cluster;
                   Rule_Storage_Ptr : not null access constant Storages.Full_Rule_Storage) is
      use Local_Loading;
   begin
      Load (Cluster_Base (This), Rule_Storage_Ptr);
   end Load;

end Nomo.Interpreter.Rewards_Clusters.Loading;
