--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Times;

with Nomo.Numerics.Accurately;

private with Nomo.Interpreter.Types_Index.Ranges;

private with Nomo.Interpreter.Beginning.Parameters;
pragma Elaborate_All (Nomo.Interpreter.Beginning.Parameters);

private with Nomo.Interpreter.Activations_Memories;
pragma Elaborate_All (Nomo.Interpreter.Activations_Memories);

private with Nomo.Interpreter.Gen_Clusters_Base;
pragma Elaborate_All (Nomo.Interpreter.Gen_Clusters_Base);

private with Nomo.Interpreter.Reflection_Rules;

private with Nomo.Interpreter.Plant.Chunks_Index;

private package Nomo.Interpreter.Reflections_Clusters is

   use Numerics.Accurately;
   use Numerics.Times;

   type Reflections_Cluster is tagged limited private;

   procedure Assume (This : in out Reflections_Cluster;
                     T    : in Positive_Time);

   function Has_Selection (This : in Reflections_Cluster) return Boolean;
   pragma Inline (Has_Selection);

   procedure Interpret (This : in out Reflections_Cluster);
   pragma Inline (Interpret);

   procedure Reinforce (This            : in out Reflections_Cluster;
                        T               : in Positive_Time;
                        First_Landmark  : in Positive_Time_Interval;
                        Second_Landmark : in Positive_Time_Interval;
                        Quantity        : in Real_Accurately_0_To_1);
   pragma Inline (Reinforce);

private

   use Types_Index.Ranges;
   use Reflection_Rules;

   type Reflective_Rule_Ptr is access all Reflection_Rule;

   package Reflections_Clusters_Base is new Gen_Clusters_Base (Reflection_Rule,
                                                               Reflective_Rule_Ptr,
                                                               Beginning.Parameters.Get_Maximum_Of_Rules_By_Type,
                                                               Adjust,
                                                               Evaluate,
                                                               Evaluate,
                                                               Is_Forget,
                                                               Is_Updatable,
                                                               Update_Relevance,
                                                               Update_Relevance);
   use Reflections_Clusters_Base;

   package Activations_Reflections_Memories is new Activations_Memories (Reflection_Rule,
                                                                         Reflective_Rule_Ptr,
                                                                         Reinforce);
   use Activations_Reflections_Memories;
   use Plant.Chunks_Index;

   type Reflections_Cluster is new Cluster_Base with record
      Activations     : Activations_Memory;
      Reflective_Type : Reflective_Type_Index;
      Chunk           : Chunk_Index := 2;
   end record;

end Nomo.Interpreter.Reflections_Clusters;
