--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Types_Index;

package Nomo.Interpreter.Premises_Index.Focus is

   use Types_Index.Types_Index_Instance;
   use Premises_Index_Instance;

   type Premises_Focus is tagged limited private;

   function Get_Type_Index (This : in Premises_Focus) return Type_Index;

   function Get_First (This : in Premises_Focus) return Premise_Index;
   pragma Postcondition(Get_First'Result /= Premise_Index'First);

   function Get_Last (This : in Premises_Focus) return Premise_Index;

   function Get_Size (This : in Premises_Focus) return Premise_Index;

private

   type Premises_Focus is tagged limited record
      Index : Type_Index;
      First : Premise_Index range 1..Premise_Index'Last := 1;
      Last  : Premise_Index := 0;
      Size  : Premise_Index := 0;
   end record;

end Nomo.Interpreter.Premises_Index.Focus;

