--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

package body Nomo.Interpreter.Premises_Index.Focus.Directories is

   function Get_Types_Range (This     : in Premises_Directory;
                             Property : in Premise_Property ) return not null access constant Types_Focus is
   begin
      return This.Types_Ranges (Property)'Unchecked_Access;
   end Get_Types_Range;

   function Get_Premises_Last (This : in Premises_Directory) return Premise_Index is
   begin
      return This.Premises_Last;
   end Get_Premises_Last;

   function Get_Internal_Premises_Range (This : in Premises_Directory;
                                         I    : in Premises_Focus_Index ) return not null access constant Premises_Focus is
   begin
      pragma Assert (This.Premises_Ranges (I).Size /= 0);
      pragma Assert (This.Premises_Ranges (I).First <= This.Premises_Ranges (I).Last);
      pragma Assert (This.Premises_Ranges (I).Last - This.Premises_Ranges (I).First + 1 = This.Premises_Ranges (I).Size);
      return This.Premises_Ranges (I)'Unchecked_Access;
   end Get_Internal_Premises_Range;

   function Get_Excitator_Last (This : in Premises_Directory) return Premise_Index is
   begin
      return This.Excitator_Last;
   end Get_Excitator_Last;

end Nomo.Interpreter.Premises_Index.Focus.Directories;
