--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Internal_Messages.Premises.Plant;
use Nomo.Internal_Messages.Premises.Plant;

package body Nomo.Interpreter.Premises_Index.Arrays.Plant is

   procedure Adjust_Trend (This        : in out Internal_Premises;
                           Last        : in Premise_Index;
                           Fitting_Nbr : in Count) is
   begin
      for I in 1..Last loop
         Adjust_Trend (This(I), Fitting_Nbr);
      end loop;
   end Adjust_Trend;

   procedure Set_Times_Span (This       : in out Internal_Premises;
                             Last       : in Premise_Index;
                             Times_Span : in Premises_Times_Span) is
   begin
      for I in 1..Last loop
         Set_Time_Span (This(I), Times_Span(I));
      end loop;
   end Set_Times_Span;

   procedure Sort (This             : in out Internal_Premises;
                   Last             : in Premise_Index;
                   Types            : in out Internal_Premises_Types;
                   Index_Properties : out Internal_Premises_Properties;
                   Properties       : in out Premises_Property) is

      --  Le trie par insertion a t choisi car le nombre de prmises est infrieur  20.

      function Compare (Type_A     : in Internal_Type_Index;
                        Type_B     : in Internal_Type_Index;
                        Property_A : in Premise_Property;
                        Property_B : in Premise_Property) return Boolean;
      function Compare (Type_A     : in Internal_Type_Index;
                        Type_B     : in Internal_Type_Index;
                        Property_A : in Premise_Property;
                        Property_B : in Premise_Property) return Boolean is
         use Types_Index.Types_Index_Instance;
      begin
         if Property_A = Property_B then
            return Type_A > Type_B;
         else
            return Property_A > Property_B;
         end if;
      end Compare;
      J               : Premise_Index;
      Buffer_Premise  : Internal_Messages.Premises.Internal_Premise;
      Buffer_Type     : Internal_Type_Index;
      Buffer_Property : Premise_Property;
   begin
      for I in  2 .. Last loop
         Set (Buffer_Premise, This (I));
         Buffer_Type := Types (I);
         Buffer_Property := Properties (I);
         J := Premise_Index'Pred (I);
         while (J >= 1) and then Compare (Types (J), Buffer_Type, Properties (J), Buffer_Property) loop
            Set (This (Premise_Index'Succ (J)), This (J));
            Types (Premise_Index'Succ (J)) := Types (J);
            Properties (Premise_Index'Succ (J)) := Properties (J);
            J := Premise_Index'Pred (J);
         end loop;
         Set (This (Premise_Index'Succ (J)), Buffer_Premise);
         Types (Premise_Index'Succ (J)) := Buffer_Type;
         Properties (Premise_Index'Succ (J)) := Buffer_Property;
      end loop;
      Index_Properties := (others => Premise_Index'First);
      for I in Premise_Index'Succ(Premise_Index'First) .. Last loop
         Index_Properties (Properties (I)) := I;
      end loop;
   end Sort;

   procedure Set (This                  : in out Internal_Premises;
                  I                     : in Premise_Index;
                  Information           : in Positive_Integer;
                  Information_Tolerance : in Boolean;
                  Time_Span             : in Time_Interval;
                  Time_Span_Tolerance   : in Strictly_Positive_Real;
                  Credibility           : in Real_0_To_1;
                  Credibility_Tolerance : in Strictly_Positive_Real) is
   begin
      Set (This (I),
           Information,
           Information_Tolerance,
           Time_Span,
           Time_Span_Tolerance,
           Credibility,
           Credibility_Tolerance);
   end Set;

end Nomo.Interpreter.Premises_Index.Arrays.Plant;
