--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Internal_Messages.Premises.Initialization;

package body Nomo.Interpreter.Premises_Index.Arrays.Initialization is

   function Get_Information (This : in Internal_Premises;
                             I    : in Premise_Index) return Positive_Integer is
      use Internal_Messages.Premises.Initialization;
   begin
      return Get_Information (This (I));
   end Get_Information;

   function Sum_Specificity_Log (This  : in Internal_Premises;
                                 First : in Premise_Index;
                                 Last  : in Premise_Index) return Real_Accurately is
      use Internal_Messages.Premises;
      Answer : Real_Accurately := 0.0;
   begin
      for I in First .. Last loop
         Answer := Answer + This (I).Get_Specificity_Log;
      end loop;
      return Answer;
   end Sum_Specificity_Log;

end Nomo.Interpreter.Premises_Index.Arrays.Initialization;
