--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Beginning.Parameters;
pragma Elaborate_All (Nomo.Interpreter.Beginning.Parameters);

with Nomo.Internal_Messages.Premises.Gen_Checking;
pragma Elaborate_All (Nomo.Internal_Messages.Premises.Gen_Checking);

package body Nomo.Interpreter.Premises_Index.Arrays.Checking is

   package Internal_Messages_Premises_Checking is new Internal_Messages.Premises.Gen_Checking (Beginning.Parameters.Get_Check_Cover);
   use Internal_Messages_Premises_Checking;

   procedure Get_Actuator (This        : in Internal_Premises;
                           I           : in Premise_Index;
                           Time_Span   : out Time_Interval;
                           Credibility : out Real_0_To_1) is
   begin
      Get_Actuator (This (I), Time_Span, Credibility);
   end Get_Actuator;

   procedure Get_New_Time_Span (This      : in Internal_Premises;
                                I         : in Premise_Index;
                                Time_Span : out Positive_Time_Interval;
                                Bonus     : out Positive_Time_Interval) is
   begin
      Get_New_Time_Span (This (I), Time_Span, Bonus);
   end Get_New_Time_Span;

   procedure Maximize(This        : in out Internal_Premises;
                      I           : in Premise_Index;
                      Fitting_Nbr : in Count) is
   begin
      This (I).Maximize (Fitting_Nbr);
   end Maximize;

   procedure Maximize_Landmark(This        : in out Internal_Premises;
                               I           : in Premise_Index;
                               Fitting_Nbr : in Count) is
   begin
      Maximize_Landmark (This (I), Fitting_Nbr);
   end Maximize_Landmark;

   procedure Set_Actuator (This        : out Internal_Premises;
                           I           : in Premise_Index;
                           Time_Span   : in Time_Interval;
                           Credibility : in Real_0_To_1) is
   begin
      Set_Actuator (This(I), Time_Span, Credibility);
   end Set_Actuator;

end Nomo.Interpreter.Premises_Index.Arrays.Checking;
