--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Times;

with Nomo.Interpreter.Types_Index;

private package Nomo.Interpreter.Plant.Targets is

   use Numerics.Times;
   use Types_Index.Types_Index_Instance;

   type Target is tagged limited record
      Arrival_Time : Positive_Time;
      Capture_Time : Positive_Time;
      Index        : Type_Index_Strict;
   end record;

   function Is_Expired (This : in Target;
                        T    : in Positive_Time) return Boolean;

end Nomo.Interpreter.Plant.Targets;
