--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Types_Index.Ranges;

with Nomo.Gen_Scopes;

with Nomo.Reader.Parameters;
pragma Elaborate_All (Nomo.Reader.Parameters);

private with Nomo.Reader.Gen_Scopes;
pragma Elaborate_All (Nomo.Reader);
pragma Elaborate_All (Nomo.Reader.Gen_Scopes);

package Nomo.Interpreter.Plant.Scopes is

   use Types_Index.Ranges;

   package Scopes_Instance is new Gen_Scopes (Reader.Parameters.Get_Number_Of_External_Scopes,
                                              Reader.Parameters.Get_Number_Of_Internal_Scopes,
                                              Natural (External_Type_Index'Last),
                                              Natural (Internal_Type_Index'Last),
                                              External_Type_Index,
                                              Internal_Type_Index);

   External_Scopes : constant Scopes_Instance.External_Scopes;
   Internal_Scopes : constant Scopes_Instance.Internal_Scopes;

private

   package Reader_Scopes is new Reader.Gen_Scopes (Scopes_Instance.External_Scopes,
                                                   Scopes_Instance.Internal_Scopes);

   External_Scopes : constant Scopes_Instance.External_Scopes := Reader_Scopes.Get_External_Scopes;
   Internal_Scopes : constant Scopes_Instance.Internal_Scopes := Reader_Scopes.Get_Internal_Scopes;

end Nomo.Interpreter.Plant.Scopes;
