--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Times;

with Nomo.Premise_Properties;

with Nomo.Interpreter.Types_Index.Ranges;

with Nomo.Internal_Messages;

with Nomo.Interpreter.External_Messages;

package Nomo.Interpreter.Plant.Rule_Buffer.Writing is

   use Numerics.Times;
   use Types_Index.Ranges;
   use Internal_Messages;

   procedure Reset_Storage;

   procedure Set_Internal_Conclusion (Index               : in Internal_Type_Index;
                                      Internal_Conclusion : in Internal_Message;
                                      Arrival_Time        : in Positive_Time;
                                      Operator            : in Positive;
                                      Is_Reference        : in Boolean);

   use Premise_Properties;

   procedure Set_Internal_Condition (Index              : in Internal_Type_Index;
                                     Internal_Condition : in Internal_Message;
                                     Arrival_Time       : in Positive_Time;
                                     Property           : in Premise_Property;
                                     Operator           : in Positive);

   use External_Messages;

   procedure Set_External_Condition (Index               : in Input_Type_Index;
                                     External_Condition  : in External_Message;
                                     Arrival_Time        : in Positive_Time;
                                     Operator            : in Positive);

   procedure Set_Temporal_Reference (Reference_Time : in Positive_Time);

end Nomo.Interpreter.Plant.Rule_Buffer.Writing;
