--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Storages.Reading;

with Nomo.Interpreter.Plant.Error;

with Nomo.Interpreter.Plant.Errors_Manager;

package body Nomo.Interpreter.Plant.Rule_Buffer.Reading is

   function Has_New_Rule return Boolean is
   begin
      if Reading_Index < Buffer_Last then
         Reading_Index := Reading_Index + 1;
         return True;
      else
         return False;
      end if;
   end Has_New_Rule;

   function Get_Type_Index return Type_Index_Strict is
   begin
      return Storages.Reading.Get_Conclusion_Type (Buffers (Reading_Index));
   end Get_Type_Index;

   function Get_Buffer return not null access Storages.Full_Rule_Storage is
   begin
      return Buffers (Reading_Index)'Access;
   end Get_Buffer;

   procedure Send_Error is
   begin
      Errors_Manager.Error (Errors_Manager.OVER_RULES);
   exception
      when Error.PARSER_FAIL =>
         null;
   end Send_Error;

end Nomo.Interpreter.Plant.Rule_Buffer.Reading;
