--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Plant.Internal_Pointers_Register;

with Nomo.Interpreter.Plant.External_Pointer;

package body Nomo.Interpreter.Plant.Pointers_Memory is

   procedure Active_Pointer (I           : in Chunk_Index;
                             Information : in Positive_Integer) is
   begin
      if I > 1 then
         Internal_Pointers_Register.Set_Scope (I, Information);
      else
         External_Pointer.Set_Scope (Information);
      end if;
   end Active_Pointer;

   procedure Cancel is
   begin
      Internal_Pointers_Register.Cancel;
      External_Pointer.Cancel;
   end Cancel;

   procedure Update_Positions (T : in Positive_Time) is
   begin
      Internal_Pointers_Register.Update_Positions (T);
      External_Pointer.Update_Position (T);
   end Update_Positions;

end Nomo.Interpreter.Plant.Pointers_Memory;
