--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Plant.Affectation_Manager;

with Nomo.Interpreter.Plant.Errors_Manager;

with Nomo.Interpreter.Plant.Internal_Chunks;

package body Nomo.Interpreter.Plant.Internal_Chunks_Register is

   use Internal_Chunks;

   Chunks : array (Internal_Chunk_Index'Range) of Internal_Chunk;
   Register : array (Internal_Chunk_Index'Range) of Internal_Chunk_Index;
   Chunk_Last : Positive := 1;

   procedure Assume_All (T : in Positive_Time) is
   begin
      for I in Register'First .. Chunk_Index (Chunk_Last) loop
         Chunks (Register (I)).Assume (T, Register (I));
      end loop;
      Chunk_Last := 1;
   end Assume_All;

   procedure Assume_With_Target (I      : in Internal_Chunk_Index;
                                 T      : in Positive_Time;
                                 Target : in Internal_Chunk_Index) is
      use Errors_Manager;
   begin
      if Chunks (Target).Is_Expired (T) then
         Error (EXPIRED_INTERNAL_CHUNCK);
      else
         Chunks (I).Assume_With_Target (I, Chunks (Target));
      end if;
      Chunk_Last := 1;
   end Assume_With_Target;

   procedure Cancel is
   begin
      Chunk_Last := 1;
   end Cancel;

   procedure Create_Perception_Forward (I            : in Internal_Chunk_Index;
                                        Capture_Time : in Positive_Time;
                                        Arrival_Time : in Positive_Time;
                                        Input_Index  : in Input_Type_Index) is
   begin
      Chunks (I).Create_Perception_Forward (Capture_Time, Arrival_Time, Input_Index);
      Chunk_Last := 1;
   end Create_Perception_Forward;

   function Get_Arrival_Time (I         : in Internal_Chunk_Index;
                              Operation : in Positive) return Positive_Time is
   begin
      return Chunks (I).Get_Arrival_Time (Operation);
   end Get_Arrival_Time;

   function Get_Capture_Time (I : in Internal_Chunk_Index) return Positive_Time is
   begin
      return Chunks (I).Get_Capture_Time;
   end Get_Capture_Time;

   function Is_Expired (I : in Internal_Chunk_Index;
                        T : in Positive_Time) return Boolean is
   begin
      return Chunks (I).Is_Expired (T);
   end Is_Expired;

   procedure Registry is
   begin
      for I in Register'First .. Chunk_Index (Chunk_Last) loop
         Affectation_Manager.Set_Internal_Operation (Register (I), Chunks (Register (I)).Get_Operation);
      end loop;
   end Registry;

   procedure Send_In_Conclusion (Reference_Chunk : in Internal_Chunk_Index) is
   begin
      for I in Register'First .. Chunk_Index (Chunk_Last) loop
         Chunks (Register (I)).Send_In_Conclusion (Reference_Chunk = Register (I));
      end loop;
      Chunk_Last := 1;
   end Send_In_Conclusion;

   procedure Send_In_Conclusion is
   begin
      for I in Register'First .. Chunk_Index (Chunk_Last) loop
         Chunks (Register (I)).Send_In_Conclusion (True);
      end loop;
      Chunk_Last := 1;
   end Send_In_Conclusion;

   procedure Send_In_Excitatory_Condition is
   begin
      for I in Register'First .. Chunk_Index (Chunk_Last) loop
         Chunks (Register (I)).Send_In_Excitatory_Condition;
      end loop;
      Chunk_Last := 1;
   end Send_In_Excitatory_Condition;

   procedure Send_In_Inhibitory_Condition is
   begin
      for I in Register'First .. Chunk_Index (Chunk_Last) loop
         Chunks (Register (I)).Send_In_Inhibitory_Condition;
      end loop;
      Chunk_Last := 1;
   end Send_In_Inhibitory_Condition;

   procedure Set_Operation (I           : in Internal_Chunk_Index;
                            Information : in Positive_Integer) is
   begin
      Chunks (I).Set_Operation (Positive (Information));
      Chunk_Last := Chunk_Last + 1;
      Register (Chunk_Index (Chunk_Last)) := I;
   end Set_Operation;

   procedure Set_Temporal_Reference (I                       : in Internal_Chunk_Index;
                                     Is_Reference_And_Origin : in Boolean) is
   begin
      Chunks (I).Set_Temporal_Reference (Is_Reference_And_Origin);
   end Set_Temporal_Reference;

end Nomo.Interpreter.Plant.Internal_Chunks_Register;
