--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Times;
with Nomo.Numerics.Informations;

with Nomo.Interpreter.Plant.Targets;

with Nomo.Interpreter.External_Events_Index;

private package Nomo.Interpreter.Plant.External_Pointer is

   use Targets;
   use Numerics.Times;
   use Numerics.Informations;
   use External_Events_Index;

   procedure Cancel;
   pragma Inline (Cancel);

   function Get_Event_Position return External_Event_Index;
   pragma Inline (Get_Event_Position);

   procedure Get_Target (Chunck_Target : out Target);

   function Is_Expired (T : in Positive_Time) return Boolean;
   pragma Inline (Is_Expired);

   procedure Set_Scope (Information : in Positive_Integer);

   procedure Update_Position (T : in Positive_Time);

end Nomo.Interpreter.Plant.External_Pointer;
