--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Times;

with Nomo.Numerics.Informations;

with Nomo.Interpreter.Types_Index.Ranges;

private package Nomo.Interpreter.Plant.External_Chunk is

   use Numerics.Times;
   use Numerics.Informations;
   use Types_Index.Ranges;

   procedure Assume(T : in Positive_Time);

   procedure Assume_With_Target (Target_Capture_Time : in Positive_Time;
                                 Target_Arrival_Time : in Positive_Time);

   procedure Cancel;
   pragma Inline (Cancel);

   function Get_Arrival_Time return Positive_Time;
   pragma Inline (Get_Arrival_Time);

   function Get_Type_Index return External_Type_Index;
   pragma Inline (Get_Type_Index);

   function Is_Active return Boolean;
   pragma Inline (Is_Active);

   function Is_Expired (T : in Positive_Time) return Boolean;
   pragma Inline (Is_Expired);

   procedure Registry;
   pragma Inline (Registry);

   procedure Send_In_Excitatory_Condition ;
   pragma Inline (Send_In_Excitatory_Condition);

   function Get_Operator return Positive;
   pragma Inline (Get_Operator);

   procedure Set_Operation (Information : in Positive_Integer);
   pragma Inline (Set_Operation);

   procedure Set_Temporal_Reference (Is_Reference_And_Origin : in Boolean);

end Nomo.Interpreter.Plant.External_Chunk;
