--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Accurately;

with Nomo.Interpreter.Conditions_Base;

private with Nomo.Interpreter.External_Messages.Premises;

private with Nomo.Interpreter.Types_Index.Ranges;

private package Nomo.Interpreter.Perception_Conditions is

   use Conditions_Base;
   use Numerics.Accurately;

   type Perception_Condition is new Condition_Base with private;

   procedure Evaluate (This  : in out Perception_Condition);

   procedure Evaluate (This  : in out Perception_Condition;
                       Shift : in Real_Accurately);

   procedure Maximize (This : in out Perception_Condition);

private

   use External_Messages.Premises;
   use Types_Index.Ranges;

   type Perception_Condition is new Condition_Base with record
      Input_Premise : External_Premise;
      Input_Type    : Input_Type_Index;
   end record;

end Nomo.Interpreter.Perception_Conditions;
