--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Types_Directory.Relations;

package body Nomo.Interpreter.Maximums_Register is

   Maximums_Informations : array (Internal_Type_Index'Range) of Positive_Integer := (others => Positive_Integer'First);

   Maximum_Rule_Id : Natural := 0;

   package body Initialization is

      procedure Set_New_Information (I           : in Internal_Type_Index;
                                     Information : in Positive_Integer) is
      begin
         if Maximums_Informations (I) < Information then
            Maximums_Informations (I) := Information;
         end if;
      end Set_New_Information;

      procedure Adjust_Information_Perceptive_Max is
         use Types_Directory.Relations;
      begin
         for I in Command_Type_Index'Range loop
            if Has_Feedback (I) and then Maximums_Informations (I) > Maximums_Informations (Get_Feedback (I)) then
               Maximums_Informations (Get_Feedback (I)) := Maximums_Informations (I);
            end if;
         end loop;
      end Adjust_Information_Perceptive_Max;

      procedure Set_New_Rule_Id (Rule_Id : in Positive) is
      begin
         if Maximum_Rule_Id < Rule_Id then
            Maximum_Rule_Id := Rule_Id;
         end if;
      end Set_New_Rule_Id;

   end Initialization;

   package body Incrementation is

      function Get_New_Information (I : in Internal_Type_Index) return Positive_Integer is
      begin
         Maximums_Informations (I) := Maximums_Informations (I) + 1;
         return Maximums_Informations (I);
      end Get_New_Information;

      function Get_Last_Information (I : in Perception_Type_Index) return Positive_Integer is
      begin
         return Maximums_Informations (I);
      end Get_Last_Information;

      function Get_New_Rule_Id return Positive is
      begin
         Maximum_Rule_Id := Maximum_Rule_Id + 1;
         return Maximum_Rule_Id;
      end Get_New_Rule_Id;

   end Incrementation;

end Nomo.Interpreter.Maximums_Register;
