--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Times;

with Nomo.Logging_Flags;

with Nomo.Interpreter.Storages;

private with Nomo.Gen_Logger;
pragma Elaborate_All (Nomo.Gen_Logger);

private with Nomo.Interpreter.Beginning.Parameters;

private with Nomo.Interpreter.Types_Index.Ranges;

private with Nomo.Interpreter.Types_Directory.Logging;

private package Nomo.Interpreter.Logger is

   use Storages;

   procedure Initialize (Log_Path : string);

   procedure Finalize;

   procedure Log_Partial (Buffer_Ptr : not null access Full_Rule_Storage);

   procedure Log_Full (Buffer_Ptr : not null access Full_Rule_Storage);

   use Numerics.Times;
   use Logging_Flags;

   procedure Set_Time (T       : in Time;
                       Context : in File_Flag);

   function Get_Directory return String;

private

   use Types_Index.Ranges;
   use Types_Directory.Logging;

   package Logger_Instance is new Gen_Logger (Partial_Storage_Size,
                                              Full_Rule_Storage,
                                              Beginning.Parameters.Get_Maximum_Of_Premises,
                                              Beginning.Parameters.Get_Maximum_Of_Components,
                                              Types_Index.Types_Index_Instance,
                                              External_Type_Index'Last,
                                              Get_Category);

   procedure Initialize (Log_Path : String) renames Logger_Instance.Initialize;

   procedure Finalize renames Logger_Instance.Finalize;

   procedure Log_Partial (Buffer_Ptr : not null access Full_Rule_Storage) renames Logger_Instance.Log_Partial;

   procedure Log_Full (Buffer_Ptr : not null access Full_Rule_Storage) renames Logger_Instance.Log_Full;

   procedure Set_Time (T       : in Time;
                       Context : in File_Flag) renames Logger_Instance.Set_Time;

   function Get_Directory return String renames Logger_Instance.Get_Directory;

end Nomo.Interpreter.Logger;
