--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Types_Directory.Relations;
pragma Elaborate_All (Nomo.Interpreter.Types_Directory.Relations);

with Nomo.Interpreter.Storages.Writing;
pragma Elaborate_All (Nomo.Interpreter.Storages.Writing);

package body Nomo.Interpreter.Log_Buffers is

   This : array (Internal_Type_Index'Range) of aliased Storages.Full_Rule_Storage;

   function Get_Storage (I : in Internal_Type_Index) return not null access Storages.Full_Rule_Storage is
   begin
      return This(I)'Access;
   end Get_Storage;

   use Types_Directory.Relations;

begin
   for I in Internal_Type_Index'Range loop
      if not(I in Anomaly_Type_Index) then
         Storages.Writing.Set_Conclusion_Type (This (I), I);
         if I in Command_Type_Index then
            Storages.Writing.Set_External_Conclusion_Size (This (I), Get_Data_Size (I));
         end if;
      end if;
   end loop;
end Nomo.Interpreter.Log_Buffers;
