--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

package Nomo.Interpreter.Internal_Events_Index.Registers.Plant is

   function Get_Before_Arrival_Time (This     : in Internal_Register;
                                     Position : in Internal_Event_Index) return Positive_Time;

   function Get_First_Arrival_Time (This     : in Internal_Register;
                                    Position : in Internal_Event_Index) return Positive_Time;

   function Get_Last_Arrival_Time (This     : in Internal_Register;
                                   Position : in Internal_Event_Index) return Positive_Time;

   function Get_After_Arrival_Time (This     : in Internal_Register;
                                    Position : in Internal_Event_Index) return Positive_Time;

   function Get_Same_Arrival_Time (This     : in Internal_Register;
                                   Position : in Internal_Event_Index) return Positive_Time;

   function Get_Before_Position (This     : in Internal_Register;
                                 Position : in Internal_Event_Index) return Internal_Event_Index;

   function Get_First_Position (This     : in Internal_Register;
                                Position : in Internal_Event_Index) return Internal_Event_Index;

   function Get_Last_Position (This     : in Internal_Register;
                               Position : in Internal_Event_Index) return Internal_Event_Index;

   function Get_After_Position (This     : in Internal_Register;
                                Position : in Internal_Event_Index) return Internal_Event_Index;

   function Get_Same_Position (This     : in Internal_Register;
                               Position : in Internal_Event_Index) return Internal_Event_Index;

   procedure Get_Current_Event (This         : in Internal_Register;
                                Position     : out Internal_Event_Index;
                                Arrival_Time : out Positive_Time);

   procedure Get_Event (This            : in Internal_Register;
                        Arrival_Time    : in out Positive_Time;
                        Internal_Data   : out Internal_Message);

   procedure Get_Event (This          : in Internal_Register;
                        Position      : in Internal_Event_Index;
                        Internal_Data : out Internal_Message);
   pragma Inline (Get_Event);

   procedure Get_Event (This          : in Internal_Register;
                        Position      : in Internal_Event_Index;
                        Arrival_Time  : out Positive_Time;
                        Internal_Data : out Internal_Message);
   pragma Inline (Get_Event);

end Nomo.Interpreter.Internal_Events_Index.Registers.Plant;
