--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Internal_Messages.Events;

with Nomo.Interpreter.Beginning.Parameters;
pragma Elaborate_All (Nomo.Interpreter.Beginning.Parameters);

package body Nomo.Interpreter.Internal_Events is

   function After (This : in Internal_Event;
                   T    : in Positive_Time) return Boolean is
   begin
      return This.Arrival_Time > T;
   end After;

   function Before (This : in Internal_Event;
                    T    : in Positive_Time) return Boolean is
   begin
      return This.Arrival_Time < T;
   end Before;

   function Is_Equal (This   : in Internal_Event;
                      Target : in Internal_Event) return Boolean is
      use Internal_Messages.Events;
   begin
      return Is_Equal (Internal_Message (This), Internal_Message (Target));
   end Is_Equal;

   function Get_Arrival_Time (This : in Internal_Event) return Positive_Time is
   begin
      return This.Arrival_Time;
   end Get_Arrival_Time;

   procedure Get_Content (This    : in Internal_Event;
                          Content : out Internal_Message) is
      use Internal_Messages.Events;
   begin
      Set (Content, Internal_Message (This));
   end Get_Content;

   procedure Get_Event (This         : in Internal_Event;
                        Arrival_Time : out Positive_Time;
                        Content      : out Internal_Message) is
      use Internal_Messages.Events;
   begin
      Arrival_Time := This.Arrival_Time;
      Set (Content, Internal_Message (This));
   end Get_Event;

   function Not_Expired (This : in Internal_Event;
                         T    : in Positive_Time) return Boolean is
   begin
      return T < This.End_Time;
   end Not_Expired;

   procedure Reset_Time_Span (This : out Internal_Event) is
      use Internal_Messages.Events;
   begin
      Reset_Time_Span (Internal_Message (This));
   end Reset_Time_Span;

   Duration_Limit : constant Positive_Time := Positive_Time (Beginning.Parameters.Get_Time_Span_Limit);

   procedure Set_Event (This         : out Internal_Event;
                        Content      : in Internal_Message;
                        Arrival_Time : in Positive_Time) is
      use Internal_Messages.Events;
   begin
      Set (Internal_Message (This), Content);
      This.Arrival_Time := Arrival_Time;
      This.End_Time := This.Arrival_Time + Duration_Limit;
   end Set_Event;


   function To_Internal_Message (This : in Internal_Event) return not null access constant Internal_Message is
   begin
      return Internal_Message (This)'Unchecked_Access;
   end To_Internal_Message;

   procedure Update_Time_Span (This         : in out Internal_Event;
                               Current_Time : in Positive_Time) is
      use Internal_Messages.Events;
   begin
      Update_Time_Span (Internal_Message (This), Time_Interval (Current_Time - This.Arrival_Time));
   end Update_Time_Span;

end Nomo.Interpreter.Internal_Events;
