--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

private with Nomo.Numerics.Accurately;

private generic
   type Rule is limited private;
   type Rule_Ptr is access Rule;
   Rules_Number : Positive;
package Nomo.Interpreter.Gen_Rules_Directories is

   pragma Pure;

   type Rules_Directory is tagged limited private;

private

   use Numerics.Accurately;

   type Reference_Index_Extend is new Natural range 0 .. Rules_Number + 1;

   subtype Reference_Index_Plus is Reference_Index_Extend range Reference_Index_Extend'First + 1 .. Reference_Index_Extend'Last;
   subtype Reference_Index_Minus is Reference_Index_Extend range Reference_Index_Extend'First .. Reference_Index_Extend'Last - 1;
   subtype Reference_Index is Reference_Index_Extend range Reference_Index_Extend'First + 1 .. Reference_Index_Extend'Last - 1;

   type Index_Tab is array (Reference_Index_Plus'Range) of Reference_Index_Plus;

   type Rule_Reference is record
      Excitatory_Specificity_Log : Real_Accurately := Real_Accurately'Last;
      Inhibitory_Specificity_Log : Real_Accurately := Real_Accurately'Last;
      Reference                  : Rule_Ptr := null;
      Final_Rule_Significantly   : Reference_Index;
   end record;

   type Rule_References is array (Reference_Index'Range) of Rule_Reference;

   type Rules_Directory is tagged limited record
      References     : Rule_References;
      Last_Reference : Reference_Index_Minus := Reference_Index_Minus'First;
      Updatables     : Index_Tab;
      Last_Updatable : Reference_Index_Minus := Reference_Index_Minus'First;
      Spaces         : Index_Tab;
      Last_Space     : Reference_Index_Minus := Reference_Index_Minus'First;
      Trash          : Rule_References;
   end record;

end Nomo.Interpreter.Gen_Rules_Directories;
