--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Accurately;

generic
   with function Is_Updatable (This : in Rule) return Boolean;
package Nomo.Interpreter.Gen_Rules_Directories.Insertion is

   use Numerics.Accurately;

   function Get_New_Reference (This : in Rules_Directory) return not null Rule_Ptr;
   pragma Inline (Get_New_Reference);

   function Has_Space (This : in Rules_Directory) return Boolean;
   pragma Inline (Has_Space);

   procedure Insert (This                       : in out Rules_Directory;
                     Excitatory_Specificity_Log : in Real_Accurately;
                     Inhibitory_Specificity_Log : in Real_Accurately);

end Nomo.Interpreter.Gen_Rules_Directories.Insertion;
