--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

package body Nomo.Interpreter.Gen_Clusters_Base.Standard_Loading is

   function Has_Space (This : in Cluster_Base) return Boolean is
   begin
      return Local_Insertion.Has_Space (Rules_Directory (This.Directory));
   end Has_Space;

   procedure Load (This             : in out Cluster_Base;
                   Rule_Storage_Ptr : not null access constant Full_Rule_Storage) is
      use Local_Insertion;
      Excitatory_Specificity_Log : Real_Accurately;
      Inhibitory_Specificity_Log : Real_Accurately;
   begin
      Initialize (Get_New_Reference (Rules_Directory (This.Directory)).all,
                  Rule_Storage_Ptr.all,
                  This.Matchmaker'Access,
                  Excitatory_Specificity_Log,
                  Inhibitory_Specificity_Log);
      Insert (Rules_Directory (This.Directory), Excitatory_Specificity_Log, Inhibitory_Specificity_Log);
   end Load;

end Nomo.Interpreter.Gen_Clusters_Base.Standard_Loading;
