--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

limited with Nomo.Interpreter.Storages;

private with Nomo.Interpreter.Landmarks_Clusters.Loading;
pragma Elaborate_All (Nomo.Interpreter.Landmarks_Clusters.Loading);

private with Nomo.Interpreter.Epistemic_Memory.Gen_Section.Loading;
pragma Elaborate_All (Nomo.Interpreter.Epistemic_Memory.Gen_Section.Loading);

package Nomo.Interpreter.Epistemic_Memory.Landmarking.Loading is

   procedure Load (I                : in Landmark_Type_Index;
                   Rule_Storage_Ptr : not null access constant Storages.Full_Rule_Storage);

   function Has_Space (I : in Landmark_Type_Index) return Boolean;

private

   use Landmarks_Clusters.Loading;

   package Landmarking_Epistemic_Memory_Loading is new Landmarking_Epistemic_Memory.Loading (Initialize,
                                                                                             Has_Space,
                                                                                             Load);

   function Has_Space (I : in Landmark_Type_Index) return Boolean renames Landmarking_Epistemic_Memory_Loading.Has_Space;

   procedure Load (I                : in Landmark_Type_Index;
                   Rule_Storage_Ptr : not null access constant Storages.Full_Rule_Storage) renames Landmarking_Epistemic_Memory_Loading.Load;

end Nomo.Interpreter.Epistemic_Memory.Landmarking.Loading;
