--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Epistemic_Memory.Checking;

with Nomo.Interpreter.Epistemic_Memory.Conceptive;

with Nomo.Interpreter.Epistemic_Memory.Landmarking;

with Nomo.Interpreter.Epistemic_Memory.Commanding;

with Nomo.Interpreter.Epistemic_Memory.Perceptive;

with Nomo.Interpreter.Epistemic_Memory.Predictive;

with Nomo.Interpreter.Epistemic_Memory.Reflective;

with Nomo.Interpreter.Epistemic_Memory.Rewarding;

package body Nomo.Interpreter.Epistemic_Memory.Interpretation is

   procedure Assume (T : in Positive_Time) is
   begin
      Checking.Assume (T);
      Conceptive.Assume (T);
      Landmarking.Assume (T);
      Commanding.Assume (T);
      Perceptive.Assume (T);
      Predictive.Assume (T);
      Reflective.Assume (T);
      Rewarding.Assume (T);
   end Assume;

   procedure Interpret is
   begin
      Checking.Interpret;
      Conceptive.Interpret;
      Landmarking.Interpret;
      Commanding.Interpret;
      Perceptive.Interpret;
      Predictive.Interpret;
      Reflective.Interpret;
      Rewarding.Interpret;
   end Interpret;

   procedure Initialize;

   procedure Initialize is separate;

begin
   Initialize;
end Nomo.Interpreter.Epistemic_Memory.Interpretation;
