--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

package body Nomo.Interpreter.Epistemic_Memory.Gen_Section.Loading is

   function Has_Space (I : in Index_Type) return boolean is
   begin
      return Has_Space (This (I));
   end Has_Space;

   procedure Load (I                : in Index_Type;
                   Rule_Storage_Ptr : not null access constant Storages.Full_Rule_Storage) is
   begin
      Load (This (I), Rule_Storage_Ptr);
   end Load;

   package body Linking is

      procedure Initialize is
      begin
         for I in Index_Type'Range loop
            if Has_Type_Associated (I) then
               Initialize_Links (This (I), Get_Cluster (Get_Type_Associated (I)).all);
            end if;
         end loop;
      end Initialize;

      procedure Update_Last (I : in Index_Type) is
      begin
         if Has_Type_Associated (I) then
            Update_Last_Link (This (I), Get_Cluster (Get_Type_Associated (I)).all);
         end if;
      end Update_Last;

   end Linking;

   function Get_Cluster (I : in Index_Type) return not null access Cluster is
   begin
      return This (I)'Unchecked_Access;
   end Get_Cluster;

begin
   for I in Index_Type'Range loop
      Initialize (This (I), I);
   end loop;
end Nomo.Interpreter.Epistemic_Memory.Gen_Section.Loading;
