--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Accurately;

with Nomo.Numerics.Times;

with Nomo.Interpreter.Types_Index.Ranges;

private with Nomo.Interpreter.Commands_Clusters;

private with Nomo.Interpreter.Epistemic_Memory.Gen_Section;
pragma Elaborate_All(Nomo.Interpreter.Epistemic_Memory.Gen_Section);

private package Nomo.Interpreter.Epistemic_Memory.Commanding is

   use Numerics.Accurately;
   use Numerics.Times;


   procedure Assume (T : in Positive_Time);

   procedure Interpret;

   use Types_Index.Ranges;

   procedure Reinforce (I               : in Command_Type_Index;
                        T               : in Positive_Time;
                        First_Landmark  : in Positive_Time_Interval;
                        Second_Landmark : in Positive_Time_Interval;
                        Quantity        : in Real_Accurately_0_To_1);

private

   use Commands_Clusters;

   package Commanding_Epistemic_Memory is new Gen_Section (Commands_Cluster,
                                                           Command_Type_Index,
                                                           Has_Selection,
                                                           Assume,
                                                           Interpret,
                                                           Reinforce);

   procedure Assume (T : in Positive_Time) renames Commanding_Epistemic_Memory.Assume;

   procedure Interpret renames Commanding_Epistemic_Memory.Interpret;

   procedure Reinforce (I               : in Command_Type_Index;
                        T               : in Positive_Time;
                        First_Landmark  : in Positive_Time_Interval;
                        Second_Landmark : in Positive_Time_Interval;
                        Quantity        : in Real_Accurately_0_To_1) renames Commanding_Epistemic_Memory.Reinforce;

end Nomo.Interpreter.Epistemic_Memory.Commanding;
