--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

limited with Nomo.Interpreter.Storages;

private with Nomo.Interpreter.Types_Directory.Relations;

private with Nomo.Interpreter.Perceptions_Clusters;

private with Nomo.Interpreter.Epistemic_Memory.Perceptive.Loading;

private with Nomo.Interpreter.Commands_Clusters.Loading;
pragma Elaborate_All (Nomo.Interpreter.Commands_Clusters.Loading);

private with Nomo.Interpreter.Epistemic_Memory.Gen_Section.Loading;
pragma Elaborate_All (Nomo.Interpreter.Epistemic_Memory.Gen_Section.Loading);

package Nomo.Interpreter.Epistemic_Memory.Commanding.Loading is

   procedure Initialize_Links;

   procedure Update_Last_Link (I : in Command_Type_Index);

   function Has_Space (I : in Command_Type_Index) return Boolean;

   procedure Load (I                : in Command_Type_Index;
                   Rule_Storage_Ptr : not null access constant Storages.Full_Rule_Storage);

private

   use Commands_Clusters.Loading;

   package Commanding_Epistemic_Memory_Loading is new Commanding_Epistemic_Memory.Loading (Initialize,
                                                                                           Has_Space,
                                                                                           Load);

   function Has_Space (I : in Command_Type_Index) return Boolean renames Commanding_Epistemic_Memory_Loading.Has_Space;

   procedure Load (I                : in Command_Type_Index;
                   Rule_Storage_Ptr : not null access constant Storages.Full_Rule_Storage) renames Commanding_Epistemic_Memory_Loading.Load;

   use Perceptions_Clusters;
   use Perceptive.Loading;
   use Types_Directory.Relations;

   package Commanding_Epistemic_Memory_Loading_Linking is new Commanding_Epistemic_Memory_Loading.Linking (Perceptions_Cluster,
                                                                                                           Perception_Type_Index,
                                                                                                           Initialize_Links,
                                                                                                           Update_Last_Link,
                                                                                                           Get_Cluster,
                                                                                                           Get_Feedback,
                                                                                                           Has_Feedback);

   procedure Initialize_Links renames Commanding_Epistemic_Memory_Loading_Linking.Initialize;

   procedure Update_Last_Link (I : in Command_Type_Index) renames Commanding_Epistemic_Memory_Loading_Linking.Update_Last;

end Nomo.Interpreter.Epistemic_Memory.Commanding.Loading;
