--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Storages.Writing;

with Nomo.Premise_Properties;

with Nomo.Interpreter.Premises_Index.Focus;

with Nomo.Interpreter.Premises_Index.Arrays.Getting;

package body Nomo.Interpreter.Conditions_Base.Logging is

   procedure Log_Full (This       : in Condition_Base;
                       Buffer_Ptr : not null access Full_Rule_Storage) is
      use Storages.Writing;
      use Premise_Properties;
      Buffer : Full_Rule_Storage renames Buffer_Ptr.all;
   begin
      for I in Premise_Property'Range loop
         declare
            Type_Range : Types_Focus renames This.Directory.Get_Types_Range (I).all;
         begin
            if Type_Range.Last /= 0 then
               Set_Condition_Property (Buffer, This.Directory.Get_Internal_Premises_Range (Type_Range.Last).all.Get_Last, I);
               for J in Type_Range.First .. Type_Range.Last loop
                  declare
                     use Premises_Index.Focus;
                     use Premises_Index.Arrays.Getting;
                     Premises_Range : Premises_Focus renames This.Directory.Get_Internal_Premises_Range (J).all;
                  begin
                     for K in Premises_Range.Get_First .. Premises_Range.Get_Last loop
                        Set_Internal_Premise (Buffer,
                                              K,
                                              Get (This.Premises, K).all,
                                              Premises_Range.Get_Type_Index);
                     end loop;
                  end;
               end loop;
            else
               Set_Condition_Property (Buffer, 0, I);
            end if;
         end;
      end loop;
      Set_Internal_Premises_Number (Buffer_Ptr.all, This.Directory.Get_Premises_Last);
   end Log_Full;

   procedure Log_Partial (This       : in Condition_Base;
                          Buffer_Ptr : not null access Full_Rule_Storage) is
      use Storages.Writing;
   begin
      Set_Credibility (Buffer_Ptr.all, This.Credibility);
      Set_Fitting_Nbr (Buffer_Ptr.all, This.Fitting_Nbr);
   end Log_Partial;

end Nomo.Interpreter.Conditions_Base.Logging;
