--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

package Nomo.Interpreter.Conditions_Base.Evaluation is

   procedure Evaluate_Internal_Exciting_Evidences (This                : in out Condition_Base;
                                                   Inhibitory_Score    : in out Positive_Real;
                                                   Excitatory_Distance : in out Positive_Real);

   procedure Evaluate_Internal_Exciting_Intentions (This                : in out Condition_Base;
                                                    Inhibitory_Score    : in out Positive_Real;
                                                    Excitatory_Distance : in out Positive_Real);

   procedure Evaluate_Internal_Inhibiting_Evidences (This             : in Condition_Base;
                                                     Inhibitory_Score : in out Positive_Real);

   procedure Evaluate_Internal_Inhibiting_Intentions (This             : in Condition_Base;
                                                      Inhibitory_Score : in out Positive_Real);

   procedure Reset_Score (This : out Condition_Base);
   pragma Inline (Reset_Score);

   procedure Subtract (This                : in out Condition_Base;
                       Excitatory_Distance : in Positive_Real;
                       Inhibitory_Score    : in Positive_Real);

   procedure Subtract (This                : in out Condition_Base;
                       Excitatory_Distance : in Positive_Real;
                       Inhibitory_Score    : in Positive_Real;
                       Shift               : in Real_Accurately);

end Nomo.Interpreter.Conditions_Base.Evaluation;
