--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Premises_Index.Arrays.Checking;

package body Nomo.Interpreter.Conditions_Base.Checking is

   use Premises_Index.Arrays.Checking;

   procedure Maximize (This       : in out Condition_Base;
                       Candidates : in Actuators_Buffer;
                       Landmark   : in Premise_Index;
                       Time_Span  : out Positive_Time_Interval;
                       Bonus      : out Positive_Time_Interval) is
   begin
      This.Fitting_Nbr := This.Fitting_Nbr + 1;
      This.Optimizable := This.Fitting_Nbr < Maximum_Of_Maximizations;
      for I in First_Excitator .. This.Directory.Get_Excitator_Last loop
         Set_Actuator (This.Premises, I, Candidates (I).Time_Span, Candidates (I).Credibility);
      end loop;
      for I in First_Excitator .. This.Directory.Get_Excitator_Last loop
         if I = Landmark then
            Maximize_Landmark (This.Premises, I, This.Fitting_Nbr);
         else
            Maximize (This.Premises, I, This.Fitting_Nbr);
         end if;
      end loop;
      Get_New_Time_Span (This.Premises, Landmark, Time_Span, Bonus);
   end Maximize;

   procedure Note (This       : in Condition_Base;
                   Candidates : out Actuators_Buffer) is
   begin
      for I in First_Excitator .. This.Directory.Get_Excitator_Last loop
         Get_Actuator (This.Premises, I, Candidates (I).Time_Span, Candidates (I).Credibility);
      end loop;
   end Note;

end Nomo.Interpreter.Conditions_Base.Checking;
