--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Event_Memory.Internal.Intuition;

package body Nomo.Interpreter.Checks_Clusters is

   procedure Assume (This : in out Checks_Cluster;
                     T    : in Positive_Time) is
      Selected_Rule : Check_Rule renames This.Selected_Rule.all;
   begin
      Selected_Rule.Adjust;
      Event_Memory.Internal.Intuition.Put_Event (This.Check_Type, Selected_Rule.Get_Conclusion.all, T);
   end Assume;

   function Has_Selection (This : in Checks_Cluster) return Boolean is
   begin
      return This.Selected_Rule /= null;
   end Has_Selection;

   procedure Assume_Selection (Selected_Rule : out Check_Rule_Ptr;
                               Tested_Rule   : in out Check_Rule_Ptr);
   pragma Precondition (Tested_Rule /= null);
   pragma Postcondition (Tested_Rule = null);

   procedure Assume_Selection (Selected_Rule : out Check_Rule_Ptr;
                               Tested_Rule   : in out Check_Rule_Ptr) is
   begin
      Selected_Rule := Tested_Rule;
      Tested_Rule := null;
   end Assume_Selection;

   procedure Interpret (This : in out Checks_Cluster) is
   begin
      This.Selected_Rule := null;
      if This.Tested_Rule /= null then
         if Check_Rules.Are_Eligible (This.Prediction_Type) then
            This.Tested_Rule.all.Evaluate;
            if This.Tested_Rule.all.Is_Ongoing then
               This.Tested_Rule.all.Add_Score;
               Update_Relevance (This.Directory);
            else
               Assume_Selection (This.Selected_Rule, This.Tested_Rule);
               Select_And_Update (This.Directory, This.Tested_Rule);
               if This.Tested_Rule /= null then
                  This.Tested_Rule.all.Add_Score;
               end if;
            end if;
         else
            Assume_Selection (This.Selected_Rule, This.Tested_Rule);
            Update_Relevance (This.Directory);
         end if;
      else
         if Check_Rules.Are_Eligible (This.Prediction_Type) then
            Select_And_Update (This.Directory, This.Tested_Rule);
            if This.Tested_Rule /= null then
               This.Tested_Rule.all.Add_Score;
            end if;
         else
            Update_Relevance (This.Directory);
         end if;
      end if;
   end Interpret;

end Nomo.Interpreter.Checks_Clusters;
