--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Rules_Base.Initialization;

with Nomo.Interpreter.Storages.Reading;

with Nomo.Interpreter.Check_Conditions.Initialization;

package body Nomo.Interpreter.Check_Rules.Initialization is

   function Get_Prediction_Information (This : in Check_Rule) return Positive_Integer is
      use Check_Conditions.Initialization;
   begin
      return Get_Prediction_Information (This.Condition);
   end Get_Prediction_Information;

   procedure Initialize (This                       : out Check_Rule;
                         Rule_Storage                     : in Full_Rule_Storage;
                         Matchmaker_Ptr             : not null access Internal_Events_Index.Matchmakers.Matchmaker;
                         Excitatory_Specificity_Log : out Real_Accurately;
                         Inhibitory_Specificity_Log : out Real_Accurately;
                         Prediction_Type            : in Prediction_Type_Index) is
      use Storages.Reading;
      use Rules_Base;
      use Rules_Base.Initialization;
      use Check_Conditions.Initialization;
      use Internal_Messages.Conclusions.Instantaneous.Initialization;
   begin
      Initialize (Rule_Base (This), Rule_Storage);
      Initialize (This.Conclusion,
                  Get_Internal_Conclusion (Rule_Storage).all);
      Initialize (This.Condition,
                  Get_Internal_Condition (Rule_Storage).all,
                  Get_Internal_Condition_Types (Rule_Storage).all,
                  Get_Internal_Condition_Properties (Rule_Storage).all,
                  Get_Internal_Premises_Number (Rule_Storage),
                  Get_Fitting_Nbr (Rule_Storage),
                  Matchmaker_Ptr,
                  Excitatory_Specificity_Log,
                  Inhibitory_Specificity_Log,
                  Prediction_Type);
   end Initialize;

   package body Initial is
      procedure Set_Linked_Prediction (This              : out Check_Rule;
                                       Linked_Prediction : access Predictive_Conclusion ) is
      begin
         if Linked_Prediction /= null then
            This.Linked_Prediction := Linked_Prediction;
            This.Linked_Prediction.all.Adjust_Prediction (This.Condition.Get_New_Bonus);
         end if;
      end Set_Linked_Prediction;
   end Initial;

   package body Inline is
      procedure Set_Linked_Prediction (This              : out Check_Rule;
                                       Linked_Prediction : not null access Predictive_Conclusion ) is
      begin
         This.Linked_Prediction := Linked_Prediction;
         This.Linked_Prediction.all.Adjust_Prediction (This.Condition.Get_New_Bonus);
      end Set_Linked_Prediction;
   end Inline;

end Nomo.Interpreter.Check_Rules.Initialization;
